'use client';

import Header from '../../../components/Header';
import MobileHeader from '../../../components/MobileHeader';
import Footer from '../../../components/Footer';
import { useTranslations } from 'next-intl';
import { useState, useEffect } from 'react';

export default function PrivacySettingsPage() {
  const t = useTranslations('PrivacySettingsPage');
  const [isDesktop, setIsDesktop] = useState(false);

  useEffect(() => {
    const checkScreenSize = () => {
      setIsDesktop(window.innerWidth >= 1024);
    };

    checkScreenSize();
    window.addEventListener('resize', checkScreenSize);

    return () => window.removeEventListener('resize', checkScreenSize);
  }, []);

    return (
    <div className="bg-[#F5F1F0]">
      {isDesktop ? (
        <div className="w-full bg-white">
          <div className="max-w-[1440px] mx-auto">
        <Header />
          </div>
          </div>
      ) : (
        <MobileHeader />
      )}
        
      <main className="flex flex-col items-center w-full px-4 lg:px-8">
        <div className="w-full max-w-[1376px]">
        {/* Title Section */}
          <section className="py-[50px]">
            <h1 className="text-[#1C1C1C] text-center font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]">
              {t('title')}
            </h1>
        </section>

        {/* Content Section */}
          <section className="pb-[60px]">
            <div className="text-black font-roboto text-lg font-light leading-[150%] whitespace-pre-line">
            {t('content')}
          </div>
        </section>
        </div>
      </main>

        <Footer />
      </div>
    );
} 